function avexp = get_exp_L(X, delta0, delta1, mu, phi,hminin,hmaxin,L)
% Calculate expectations component (average expected short-term interest
% rate) of long-term interest rate
% Bauer, Rudebusch, Wu (2014, AER) Comment on ``Term Premia and
% Inflation Uncertainty: Empirical Evidence from an International Panel Dataset''
%
% Arguments:
%  X - TxN matrix with risk factors
%  delta0, delta1 - parameters of short-rate equation
%  mu, phi - VAR parameters
%
% Returns:
%  avexp - expectations component of forward rate from hmin to hmax
%


[T,N] = size(X);
hmax=hmaxin+L;
hmin=hminin+L;
avexp = zeros(T, 1);
for t=L+1:T
    g = zeros(N, hmax);
    g(:,1:L)=X(t-L+1:t,:)';
    for j=L+1:hmax
        xmat=[];
        for i=1:L
            xmat=[xmat;g(:,j-i)];
        end
        
        g(:,j)=mu+(phi*xmat);
    end;
    g=g(1:3,hmin:hmax);
    avexp(t)=mean(max(delta0+(delta1'*g),0));
end;
avexp=avexp(L+1:end,:);
